<?php
// অ্যাপ কনফিগারেশন
define('SITE_NAME', 'HGZY GAME');
define('BASE_URL', 'http://localhost/hgzy');

// কমিশন রেট (0.6%)
define('COMM_RATE', 0.006);

// ডিপোজিট/উইথড্র সেটিংস
define('MIN_DEPOSIT', 100);
define('MIN_WITHDRAW', 200);
define('MAX_WITHDRAW', 50000);

// গেম সেটিংস
define('MIN_BET', 10);
define('BET_MULTIPLIERS', [
    'Green' => 2,
    'Red' => 2,
    'Violet' => 4.5,
    'Big' => 2,
    'Small' => 2,
    '0' => 9,
    '1' => 9,
    '2' => 9,
    '3' => 9,
    '4' => 9,
    '5' => 9,
    '6' => 9,
    '7' => 9,
    '8' => 9,
    '9' => 9
]);

// কালার ম্যাপিং
$COLOR_MAP = [
    0 => ['Red', 'Violet'],
    1 => ['Green'],
    2 => ['Red'],
    3 => ['Green'],
    4 => ['Red'],
    5 => ['Green', 'Violet'],
    6 => ['Red'],
    7 => ['Green'],
    8 => ['Red'],
    9 => ['Green']
];

// সাইজ ম্যাপিং
function getSize($number) {
    return $number >= 5 ? 'Big' : 'Small';
}

// অ্যালার্ট ফাংশন
function alertMsg($type, $message) {
    $_SESSION['alert'] = ['type' => $type, 'message' => $message];
}

// রিডাইরেক্ট ফাংশন
function redirect($url) {
    header("Location: $url");
    exit();
}

// সিকিউরিটি ফাংশন
function sanitize($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

// র‍্যান্ডম UIID জেনারেট
function generateUiId() {
    return rand(10000000, 99999999);
}

// পাসওয়ার্ড হ্যাশ
function hashPassword($password) {
    return password_hash($password, PASSWORD_BCRYPT);
}

// পাসওয়ার্ড ভেরিফাই
function verifyPassword($password, $hash) {
    return password_verify($password, $hash);
}
?>